diff -c3 -o -r ./change31.doc \povray3/change31.doc
*** ./change31.doc	Tue Sep 29 13:33:40 1998
--- \povray3/change31.doc	Mon Jan 18 19:39:20 1999
***************
*** 1,5 ****
--- 1,34 ----
  This file is a historical record of changes to POV-Ray 3.1 as we develop it.
  
+ 3.1b               1/18/99 Chris Young
+ Blob elements transformed after textures now works
+ Can now declare 2D vectors
+ Can now declare 4D vectors
+ Can now declare 5D vectors as colors
+ Fixed vector.v bug
+ Partial fix to bump_map bugs
+ Fixed bug involving "once" and "interpolate"
+ Fixed reflection leak bug
+ Fixed potential GPF in ListReflect
+ Fixed normal checker, hexagon bug
+ Fixed skysphere with no color_map crash
+ Fixed transform identifier parsing problem
+ Fixed #local with same name as #declare of different type bug
+ Fixed average normal bug and other normal flipping problems
+ Removed double_illuminate for normal{} but retained it for 
+  smooth_triangle, smoothed height_fields, and bicubic_patch.
+  Will redesign in 3.5 and consider added optional keyword double_illuminate.
+ Fixed normal{average} with no map crash
+ Fixed various conic_sweep prism bugs
+ Change in resumed render line numbering
+ Fixed focal blur gamma correction bug
+ Fixed recursive include overflow bug
+ Fixed recursive macro overflow bug
+ Fixed #write double closing which crashed Linux
+ Delete degenerate smooth_triangles when normals bend too much.
+ Many MS-Dos changes so C++ compiler can be used.
+ Changed EPSILON small value in MS-Dos version
+ 
  3.1a               9/29/98 Chris Young
  Fixed problem with sor and lathe affecting unix and amiga
  Fixed fclose in FILE_EXISTS
diff -c3 -o -r ./source/blob.c \povray3/source/blob.c
*** ./source/blob.c	Mon Aug 31 18:56:16 1998
--- \povray3/source/blob.c	Tue Jan  5 21:34:12 1999
***************
*** 3141,3146 ****
--- 3141,3148 ----
  {
    TRANSFORM Trans;
  
+   Compute_Translation_Transform(&Trans, Vector);
+ 
    if (Element->Trans == NULL)
    {
      /* This is a sphere component. */
***************
*** 3151,3158 ****
    {
      /* This is one of the other components. */
  
-     Compute_Translation_Transform(&Trans, Vector);
- 
      Transform_Blob_Element(Element, &Trans);
    }
  
--- 3153,3158 ----
***************
*** 3263,3268 ****
--- 3263,3270 ----
      }
    }
  
+   Compute_Scaling_Transform(&Trans, Vector);
+ 
    if (Element->Trans == NULL)
    {
      /* This is a sphere component. */
***************
*** 3274,3281 ****
    else
    {
      /* This is one of the other components. */
- 
-     Compute_Scaling_Transform(&Trans, Vector);
  
      Transform_Blob_Element(Element, &Trans);
    }
--- 3276,3281 ----
diff -c3 -o -r ./source/express.c \povray3/source/express.c
*** ./source/express.c	Mon Sep 28 14:02:24 1998
--- \povray3/source/express.c	Thu Jan 14 14:48:42 1999
***************
*** 564,569 ****
--- 564,583 ----
         EXIT
       END_CASE
  
+      CASE (UV_ID_TOKEN)
+        *Terms=2;
+        for (i=0; i<2; i++)
+          Express[i]=(DBL)(  ((DBL *)(Token.Data))[i]  );
+        EXIT
+      END_CASE
+ 
+      CASE (VECTOR_4D_ID_TOKEN)
+        *Terms=4;
+        for (i=0; i<4; i++)
+          Express[i]=(DBL)(  ((DBL *)(Token.Data))[i]  );
+        EXIT
+      END_CASE
+ 
       CASE (T_TOKEN)
         *Terms=4;
         Express[0]=0.0;
***************
*** 623,628 ****
--- 637,643 ----
       CASE (LEFT_ANGLE_TOKEN)
         Express[X] = Parse_Float();   Parse_Comma();
         Express[Y] = Parse_Float();   Parse_Comma();
+        *Terms=2;
  
         EXPECT
           CASE_EXPRESS
***************
*** 865,871 ****
         Promote_Express(Express,Terms,Local_Terms);
  
         for(i=0;i<*Terms;i++)
!          Express[i] /= Local_Express[i];
       END_CASE
  
       OTHERWISE
--- 880,896 ----
         Promote_Express(Express,Terms,Local_Terms);
  
         for(i=0;i<*Terms;i++)
!        {
!          if (Local_Express[i]==0.0) /* must be 0.0, not EPSILON */
!          {
!            Express[i]=HUGE_VAL;
!            Warn(0.0,"Divide by zero.");
!          }
!          else
!          {
!            Express[i] /= Local_Express[i];
!          }
!        }
       END_CASE
  
       OTHERWISE
***************
*** 1421,1429 ****
  *
  ******************************************************************************/
  
! void Parse_Vector_Float(VECTOR Vector)
  {
-    EXPRESS Express;
     int Terms;
  
     /* Initialize expression. [DB 12/94] */
--- 1446,1453 ----
  *
  ******************************************************************************/
  
! int Parse_Unknown_Vector(EXPRESS Express)
  {
     int Terms;
  
     /* Initialize expression. [DB 12/94] */
***************
*** 1436,1456 ****
     Terms=1;
  
     if (opts.Language_Version < 1.5)
!           Parse_Num_Factor(Express,&Terms);
     else
        Parse_Rel_Factor(Express,&Terms);
! 
!    if (Terms>3)
!       Error ("Vector or float expected but color expression found.");
! 
!    Have_Vector=(Terms==3);
! 
!    if (Have_Vector)
!      for(Terms=0;Terms<3;Terms++)
!        Vector[Terms]=Express[Terms];
!    else
!      for(Terms=0;Terms<3;Terms++)
!        Vector[Terms]=Express[0];
    }
  
  
--- 1460,1474 ----
     Terms=1;
  
     if (opts.Language_Version < 1.5)
!    {
!       Parse_Num_Factor(Express,&Terms);
!    }
     else
+    {
        Parse_Rel_Factor(Express,&Terms);
!    }
!    
!    return(Terms);
    }
  
  
diff -c3 -o -r ./source/express.h \povray3/source/express.h
*** ./source/express.h	Fri May 22 16:47:40 1998
--- \povray3/source/express.h	Wed Jan  6 19:25:02 1999
***************
*** 62,68 ****
  void Parse_UV_Vect (UV_VECT UV_Vect);
  void Parse_Vector (VECTOR Vector);
  void Parse_Vector4D (VECTOR Vector);
! void Parse_Vector_Float (VECTOR Vector);
  void Parse_Scale_Vector (VECTOR Vector);
  DBL Parse_Float_Param (void);
  void Parse_Float_Param2 (DBL *Val1, DBL *Val2);
--- 62,68 ----
  void Parse_UV_Vect (UV_VECT UV_Vect);
  void Parse_Vector (VECTOR Vector);
  void Parse_Vector4D (VECTOR Vector);
! int Parse_Unknown_Vector (EXPRESS Express);
  void Parse_Scale_Vector (VECTOR Vector);
  DBL Parse_Float_Param (void);
  void Parse_Float_Param2 (DBL *Val1, DBL *Val2);
diff -c3 -o -r ./source/frame.h \povray3/source/frame.h
*** ./source/frame.h	Mon Sep 28 15:04:44 1998
--- \povray3/source/frame.h	Wed Jan  6 20:01:18 1999
***************
*** 633,638 ****
--- 633,639 ----
  
  typedef DBL UV_VECT [2];
  typedef DBL VECTOR [3];
+ typedef DBL VECTOR_4D [4];
  typedef DBL MATRIX [4][4];
  typedef DBL EXPRESS [5];
  typedef COLC COLOUR [5];
***************
*** 721,726 ****
--- 722,730 ----
  
  #define Assign_UV_Vect(d,s) memcpy((d),(s),sizeof(UV_VECT))
  #define Destroy_UV_Vect(x)  if ((x)!=NULL) POV_FREE(x)
+ 
+ #define Assign_Vector_4D(d,s) memcpy((d),(s),sizeof(VECTOR_4D))
+ #define Destroy_Vector_4D(x)  if ((x)!=NULL) POV_FREE(x)
  
  #define Assign_Colour(d,s)  memcpy((d),(s),sizeof(COLOUR))
  #define Make_Colour(c,r,g,b) {(c)[RED]=(r);(c)[GREEN]=(g);(c)[BLUE]=(b);(c)[FILTER]=0.0;(c)[TRANSM]=0.0;}
diff -c3 -o -r ./source/image.c \povray3/source/image.c
*** ./source/image.c	Fri May 22 16:47:48 1998
--- \povray3/source/image.c	Fri Jan 15 16:31:56 1999
***************
*** 303,309 ****
      p1[Y] = Amount * (0.229 * colour1[RED] + 0.587 * colour1[GREEN] + 0.114 * colour1[BLUE]);
      p1[Z] = 0;
  
!     p2[X] = 0;
      p2[Y] = Amount * (0.229 * colour2[RED] + 0.587 * colour2[GREEN] + 0.114 * colour2[BLUE]);
      p2[Z] = 1;
  
--- 303,309 ----
      p1[Y] = Amount * (0.229 * colour1[RED] + 0.587 * colour1[GREEN] + 0.114 * colour1[BLUE]);
      p1[Z] = 0;
  
!     p2[X] = -1;
      p2[Y] = Amount * (0.229 * colour2[RED] + 0.587 * colour2[GREEN] + 0.114 * colour2[BLUE]);
      p2[Z] = 1;
  
***************
*** 317,323 ****
      p1[Y] = Amount * index;
      p1[Z] = 0;
  
!     p2[X] = 0;
      p2[Y] = Amount * index2;
      p2[Z] = 1;
  
--- 317,323 ----
      p1[Y] = Amount * index;
      p1[Z] = 0;
  
!     p2[X] = -1;
      p2[Y] = Amount * index2;
      p2[Z] = 1;
  
***************
*** 334,339 ****
--- 334,340 ----
    VNormalize(bump_normal, bump_normal);
  
    Assign_Vector(yprime, normal);
+   VScaleEq(yprime, -1);
    Make_Vector(Temp, 0.0, 1.0, 0.0);
    VCross(xprime, yprime, Temp);
    VLength(Length, xprime);
***************
*** 923,950 ****
    int iycoor, ixcoor;
    IMAGE_COLOUR *map_colour;
  
!   if (xcoor < 0.0)
    {
!     xcoor += (DBL)Image->iwidth;
    }
    else
    {
!     if (xcoor >= (DBL)Image->iwidth)
!     {
!       xcoor -= (DBL)Image->iwidth;
!     }
!   }
! 
!   if (ycoor < 0.0)
!   {
!     ycoor += (DBL)Image->iheight;
!   }
!   else
!   {
!     if (ycoor >= (DBL)Image->iheight)
!     {
!       ycoor -= (DBL)Image->iheight;
!     }
    }
  
    iycoor = (int)ycoor;
--- 924,980 ----
    int iycoor, ixcoor;
    IMAGE_COLOUR *map_colour;
  
!   if(Image->Once_Flag)
    {
!      if (xcoor < 0.0)
!      {
!        xcoor = 0.0;
!      }
!      else
!      {
!        if (xcoor >= (DBL)Image->iwidth)
!        {
!          xcoor -= 1.0;
!        }
!      }
!    
!      if (ycoor < 0.0)
!      {
!        ycoor = 0.0;
!      }
!      else
!      {
!        if (ycoor >= (DBL)Image->iheight)
!        {
!          ycoor -= 1.0;
!        }
!      }
    }
    else
    {
!      if (xcoor < 0.0)
!      {
!        xcoor += (DBL)Image->iwidth;
!      }
!      else
!      {
!        if (xcoor >= (DBL)Image->iwidth)
!        {
!          xcoor -= (DBL)Image->iwidth;
!        }
!      }
!    
!      if (ycoor < 0.0)
!      {
!        ycoor += (DBL)Image->iheight;
!      }
!      else
!      {
!        if (ycoor >= (DBL)Image->iheight)
!        {
!          ycoor -= (DBL)Image->iheight;
!        }
!      }
    }
  
    iycoor = (int)ycoor;
diff -c3 -o -r ./source/lighting.c \povray3/source/lighting.c
*** ./source/lighting.c	Thu Jul 23 11:43:56 1998
--- \povray3/source/lighting.c	Mon Jan 18 16:04:44 1999
***************
*** 139,147 ****
  static void Diffuse (FINISH *Finish, VECTOR IPoint, RAY *Eye, VECTOR Layer_Normal,
    COLOUR Layer_Pigment_Colour, COLOUR Colour,DBL Attenuation, OBJECT *Object);
  
! static void Reflect (VECTOR, RAY*, VECTOR, COLOUR, DBL);
  
! static int Refract (INTERIOR*, VECTOR, RAY*, VECTOR, COLOUR, DBL);
  
  static void filter_shadow_ray (INTERSECTION *Ray_Intersection,
    RAY *Light_Source_Ray, COLOUR Colour);
--- 139,147 ----
  static void Diffuse (FINISH *Finish, VECTOR IPoint, RAY *Eye, VECTOR Layer_Normal,
    COLOUR Layer_Pigment_Colour, COLOUR Colour,DBL Attenuation, OBJECT *Object);
  
! static void Reflect (VECTOR, RAY*, VECTOR, VECTOR, COLOUR, DBL);
  
! static int Refract (INTERIOR*, VECTOR, RAY*, VECTOR, VECTOR, COLOUR, DBL);
  
  static void filter_shadow_ray (INTERSECTION *Ray_Intersection,
    RAY *Light_Source_Ray, COLOUR Colour);
***************
*** 395,400 ****
--- 395,401 ----
    int i, Texture_Count;
    size_t savelights_size, save_tw_size;
    DBL *save_Weights = NULL;
+   DBL Normal_Direction;
    COLOUR C1;
    VECTOR Raw_Normal;
    VECTOR IPoint;
***************
*** 428,433 ****
--- 429,443 ----
  
    Normal(Raw_Normal, Ray_Intersection->Object, Ray_Intersection);
  
+   /* If the surface normal points away, flip its direction. */
+ 
+   VDot(Normal_Direction, Raw_Normal, Ray->Direction);
+ 
+   if (Normal_Direction > 0.0)
+   {
+      VScaleEq(Raw_Normal, -1.0);
+   }
+ 
    /*
     * Save texture and weight lists.
     */
***************
*** 1832,1838 ****
  *
  ******************************************************************************/
  
! static void Reflect(VECTOR IPoint, RAY *Ray, VECTOR Normal, COLOUR Colour, DBL Weight)
  {
    DBL n;
    RAY NRay;
--- 1842,1848 ----
  *
  ******************************************************************************/
  
! static void Reflect(VECTOR IPoint, RAY *Ray, VECTOR Normal, VECTOR Raw_Normal, COLOUR Colour, DBL Weight)
  {
    DBL n;
    RAY NRay;
***************
*** 1841,1849 ****
  
    /* Get direction of reflected ray. */
  
!   n = -2.0 * (Ray->Direction[X] * Normal[X] + Ray->Direction[Y] * Normal[Y] + Ray->Direction[Z] * Normal[Z]);
  
!   VLinComb2(NRay.Direction, n, Normal, 1.0, Ray->Direction);
  
    Assign_Vector(NRay.Initial, IPoint);
  
--- 1851,1890 ----
  
    /* Get direction of reflected ray. */
  
!   VDot(n,Ray->Direction, Normal);
!   n *= -2.0;
!   VAddScaled(NRay.Direction, Ray->Direction, n, Normal);
! 
!   /* Nathan Kopp & CEY 1998 - Reflection bugfix
!     if the new ray is going the opposet direction as raw normal, we
!     need to fix it.
!     */
! 
!   VDot(n, NRay.Direction, Raw_Normal);
  
!   if (n < 0.0)
!   {
!     /* It needs fixing.  Which kind? */
! 
!     VDot(n,NRay.Direction,Normal);
! 
!     if (n < 0.0)
!     {
!       /* reflected inside rear virtual surface. Reflect Ray using Raw_Normal */
!       VDot(n,Ray->Direction,Raw_Normal);
!       n *= -2.0;
!       VAddScaled(NRay.Direction, Ray->Direction, n,Raw_Normal);
!     }
!     else
!     {
!       /* Double reflect NRay using Raw_Normal */
!       VDot(n,NRay.Direction,Raw_Normal);
!       n *= -2.0;
!       VAddScaledEq(NRay.Direction, n, Raw_Normal);
!     }
!   }
!   VNormalizeEq(NRay.Direction);
!   /* NK & CEY ---- */
  
    Assign_Vector(NRay.Initial, IPoint);
  
***************
*** 1904,1910 ****
  *
  ******************************************************************************/
  
! static int Refract(INTERIOR *Interior, VECTOR IPoint, RAY *Ray, VECTOR Normal, COLOUR Colour, DBL Weight)
  {
    int nr;
    DBL n, t, ior;
--- 1945,1951 ----
  *
  ******************************************************************************/
  
! static int Refract(INTERIOR *Interior, VECTOR IPoint, RAY *Ray, VECTOR Normal, VECTOR Raw_Normal, COLOUR Colour, DBL Weight)
  {
    int nr;
    DBL n, t, ior;
***************
*** 2002,2008 ****
  
        Increase_Counter(stats[Internal_Reflected_Rays_Traced]);
  
!       Reflect(IPoint, Ray, Normal, Colour, Weight);
  
        return(1);
      }
--- 2043,2049 ----
  
        Increase_Counter(stats[Internal_Reflected_Rays_Traced]);
  
!       Reflect(IPoint, Ray, Normal, Raw_Normal, Colour, Weight);
  
        return(1);
      }
***************
*** 2249,2255 ****
  *
  *   Texture          - a linked list of texture layers
  *   IPoint           - point to be evaluated
! *   RawNormal       - non-purturbed surface normal
  *   Ray              - needed for reflection and highlighs
  *   Weight           - ADC control value
  *   Intersection - current intersection (need object type and depth)
--- 2290,2296 ----
  *
  *   Texture          - a linked list of texture layers
  *   IPoint           - point to be evaluated
! *   Raw_Normal       - non-purturbed surface normal
  *   Ray              - needed for reflection and highlighs
  *   Weight           - ADC control value
  *   Intersection - current intersection (need object type and depth)
***************
*** 2284,2290 ****
  *
  ******************************************************************************/
  
! static void compute_lighted_texture(COLOUR ResCol, TEXTURE *Texture, VECTOR IPoint, VECTOR  RawNormal, RAY *Ray, DBL Weight, INTERSECTION *Intersection)
  {
    int i, radiosity_done, radiosity_needed;
    int layer_number;
--- 2325,2331 ----
  *
  ******************************************************************************/
  
! static void compute_lighted_texture(COLOUR ResCol, TEXTURE *Texture, VECTOR IPoint, VECTOR  Raw_Normal, RAY *Ray, DBL Weight, INTERSECTION *Intersection)
  {
    int i, radiosity_done, radiosity_needed;
    int layer_number;
***************
*** 2354,2368 ****
       * for the code inside the loop, which is first-time-through.
       */
  
-     /* If the surface normal points away, flip its direction. */
- 
-     VDot(Normal_Direction, RawNormal, Ray->Direction);
- 
-     if (Normal_Direction > 0.0)
-     {
-       VScaleEq(RawNormal, -1.0);
-     }
- 
      radiosity_needed = 1;
    }
    else
--- 2395,2400 ----
***************
*** 2383,2389 ****
    {
      /* Get perturbed surface normal. */
  
!     Assign_Vector(LayNormal, RawNormal);
  
      if ((opts.Quality_Flags & Q_NORMAL) && (Layer->Tnormal != NULL))
      {
--- 2415,2421 ----
    {
      /* Get perturbed surface normal. */
  
!     Assign_Vector(LayNormal, Raw_Normal);
  
      if ((opts.Quality_Flags & Q_NORMAL) && (Layer->Tnormal != NULL))
      {
***************
*** 2390,2404 ****
        Perturb_Normal(LayNormal, Layer->Tnormal, IPoint);
      }
  
-     /* If the surface normal points away, flip its direction. */
- 
-     VDot(Normal_Direction, LayNormal, Ray->Direction);
- 
-     if (Normal_Direction > 0.0)
-     {
-       VScaleEq(LayNormal, -1.0);
-     }
- 
      /* Store top layer normal.*/
  
      if (!layer_number)
--- 2422,2427 ----
***************
*** 2465,2471 ****
  
            if (Max_Radiosity_Contribution > BLACK_LEVEL * 3.0)
            {
!             (void)Compute_Ambient(Intersection->IPoint, RawNormal, AmbCol, Weight * Max_Radiosity_Contribution);
  
              radiosity_done = TRUE;
            }
--- 2488,2494 ----
  
            if (Max_Radiosity_Contribution > BLACK_LEVEL * 3.0)
            {
!             (void)Compute_Ambient(Intersection->IPoint, Raw_Normal, AmbCol, Weight * Max_Radiosity_Contribution);
  
              radiosity_done = TRUE;
            }
***************
*** 2498,2504 ****
  
        Assign_Vector(ListNormal[layer_number], LayNormal);
  
!       Assign_Colour(ListReflec[layer_number], Layer->Finish->Reflection);
      }
  
      /* Get new filter color. */
--- 2521,2529 ----
  
        Assign_Vector(ListNormal[layer_number], LayNormal);
  
!       ListReflec[layer_number][0]=Layer->Finish->Reflection[0];
!       ListReflec[layer_number][1]=Layer->Finish->Reflection[1];
!       ListReflec[layer_number][2]=Layer->Finish->Reflection[2];
      }
  
      /* Get new filter color. */
***************
*** 2536,2542 ****
  
      /* Trace refracted ray. */
  
!     TIR_occured = Refract(Interior, Intersection->IPoint, Ray, TopNormal, RfrCol, New_Weight);
  
      /* Get distance based attenuation. */
  
--- 2561,2567 ----
  
      /* Trace refracted ray. */
  
!     TIR_occured = Refract(Interior, Intersection->IPoint, Ray, TopNormal, Raw_Normal, RfrCol, New_Weight);
  
      /* Get distance based attenuation. */
  
***************
*** 2601,2607 ****
          {
            TempWeight = ListWeight[i] * max3(ListReflec[i][0], ListReflec[i][1], ListReflec[i][2]);
  
!           Reflect(Intersection->IPoint, Ray, ListNormal[i], RflCol, TempWeight);
            
            if (ListReflEx[i] != 1.0)
            {
--- 2626,2632 ----
          {
            TempWeight = ListWeight[i] * max3(ListReflec[i][0], ListReflec[i][1], ListReflec[i][2]);
  
!           Reflect(Intersection->IPoint, Ray, ListNormal[i], Raw_Normal, RflCol, TempWeight);
            
            if (ListReflEx[i] != 1.0)
            {
diff -c3 -o -r ./source/matrices.c \povray3/source/matrices.c
*** ./source/matrices.c	Tue Jun 16 13:18:32 1998
--- \povray3/source/matrices.c	Wed Jan  6 21:34:16 1999
***************
*** 1190,1194 ****
--- 1190,1218 ----
    r[3][0] = -d03/D; r[3][1] =  d13/D;  r[3][2] = -d23/D; r[3][3] =  d33/D;
  }
  
+ UV_VECT *Create_UV_Vect ()
+ {
+   UV_VECT *New;
  
+   New = (UV_VECT *)POV_MALLOC(sizeof (UV_VECT), "uv vector");
+ 
+   (*New)[0]= 0.0;
+   (*New)[1]= 0.0;
+ 
+   return (New);
+ }
+ 
+ VECTOR_4D *Create_Vector_4D ()
+ {
+   VECTOR_4D *New;
+ 
+   New = (VECTOR_4D *)POV_MALLOC(sizeof (VECTOR_4D), "4d vector");
+ 
+   (*New)[0]= 0.0;
+   (*New)[1]= 0.0;
+   (*New)[2]= 0.0;
+   (*New)[3]= 0.0;
+ 
+   return (New);
+ }
  
diff -c3 -o -r ./source/matrices.h \povray3/source/matrices.h
*** ./source/matrices.h	Fri May 22 16:48:06 1998
--- \povray3/source/matrices.h	Wed Jan  6 19:39:06 1999
***************
*** 76,82 ****
--- 76,84 ----
  void Compute_Coordinate_Transform (TRANSFORM *trans, VECTOR origin, VECTOR up, DBL r, DBL len);
  TRANSFORM *Create_Transform (void);
  TRANSFORM *Copy_Transform (TRANSFORM *Old);
+ UV_VECT *Create_UV_Vect (void);
  VECTOR *Create_Vector (void);
+ VECTOR_4D *Create_Vector_4D (void);
  DBL *Create_Float (void);
  void MInvers (MATRIX r, MATRIX m);
  
diff -c3 -o -r ./source/mem.h \povray3/source/mem.h
*** ./source/mem.h	Fri May 22 16:48:06 1998
--- \povray3/source/mem.h	Tue Dec  1 16:05:40 1998
***************
*** 22,29 ****
  *****************************************************************************/
  
  
! #ifndef MEM_H
! #define MEM_H
  
  
  
--- 22,29 ----
  *****************************************************************************/
  
  
! #ifndef POV_MEM_H
! #define POV_MEM_H
  
  
  
diff -c3 -o -r ./source/normal.c \povray3/source/normal.c
*** ./source/normal.c	Wed Jun  3 17:05:10 1998
--- \povray3/source/normal.c	Thu Jan  7 16:02:10 1999
***************
*** 587,592 ****
--- 587,597 ----
    int i;
    BLEND_MAP *Blend_Map;
    BLEND_MAP_ENTRY *Prev, *Cur;
+   
+   if (Tnormal==NULL)
+   {
+     return;
+   }
  
    /* If normal_map present, use it and return */
  
diff -c3 -o -r ./source/optout.h \povray3/source/optout.h
*** ./source/optout.h	Tue Sep 29 12:37:14 1998
--- \povray3/source/optout.h	Sun Oct  4 17:54:54 1998
***************
*** 33,39 ****
  
  /* These are used by OPTOUT.C and the machine specific modules */
  
! #define POV_RAY_VERSION "3.1a"
  
  #define DISTRIBUTION_MESSAGE_1 "This is an unofficial version compiled by:"
  #define DISTRIBUTION_MESSAGE_2 "FILL IN NAME HERE........................."
--- 33,39 ----
  
  /* These are used by OPTOUT.C and the machine specific modules */
  
! #define POV_RAY_VERSION "3.1b"
  
  #define DISTRIBUTION_MESSAGE_1 "This is an unofficial version compiled by:"
  #define DISTRIBUTION_MESSAGE_2 "FILL IN NAME HERE........................."
diff -c3 -o -r ./source/parse.c \povray3/source/parse.c
*** ./source/parse.c	Thu Aug 13 17:20:28 1998
--- \povray3/source/parse.c	Mon Jan 18 15:34:36 1999
***************
*** 3961,3966 ****
--- 3961,3967 ----
     RAINBOW  *Local_Rainbow;
     FOG  *Local_Fog;
     SKYSPHERE  *Local_Skysphere;
+    int i;
  
     EXPECT
       CASE (RAINBOW_TOKEN)
***************
*** 3977,3982 ****
--- 3978,3987 ----
           Destroy_Skysphere(Frame.Skysphere);
         }
         Frame.Skysphere = Local_Skysphere;
+        for (i=0; i<Local_Skysphere->Count; i++)
+        {
+          Post_Pigment(Local_Skysphere->Pigments[i]);
+        }
       END_CASE
  
       CASE (FOG_TOKEN)
***************
*** 4726,4732 ****
     EXPECT
       CASE(TRANSFORM_ID_TOKEN)
         Compose_Transforms (New, (TRANSFORM *)Token.Data);
!        EXIT
       END_CASE
  
       CASE (TRANSLATE_TOKEN)
--- 4731,4741 ----
     EXPECT
       CASE(TRANSFORM_ID_TOKEN)
         Compose_Transforms (New, (TRANSFORM *)Token.Data);
!      END_CASE
! 
!      CASE (TRANSFORM_TOKEN)
!        GET(TRANSFORM_ID_TOKEN)
!        Compose_Transforms(New, (TRANSFORM *)Token.Data);
       END_CASE
  
       CASE (TRANSLATE_TOKEN)
***************
*** 4813,4819 ****
      CASE4 (COLOUR_MAP_ID_TOKEN, TRANSFORM_ID_TOKEN, CAMERA_ID_TOKEN, PIGMENT_ID_TOKEN)
      CASE4 (SLOPE_MAP_ID_TOKEN,NORMAL_MAP_ID_TOKEN,TEXTURE_MAP_ID_TOKEN,COLOUR_ID_TOKEN)
      CASE4 (PIGMENT_MAP_ID_TOKEN, MEDIA_ID_TOKEN,STRING_ID_TOKEN,INTERIOR_ID_TOKEN)
!     CASE3 (DENSITY_MAP_ID_TOKEN, ARRAY_ID_TOKEN, DENSITY_ID_TOKEN)
      CASE4 (RAINBOW_ID_TOKEN, FOG_ID_TOKEN, SKYSPHERE_ID_TOKEN,MATERIAL_ID_TOKEN)
        if (Local_Flag && (Token.Table_Index != Table_Index))
        {
--- 4822,4828 ----
      CASE4 (COLOUR_MAP_ID_TOKEN, TRANSFORM_ID_TOKEN, CAMERA_ID_TOKEN, PIGMENT_ID_TOKEN)
      CASE4 (SLOPE_MAP_ID_TOKEN,NORMAL_MAP_ID_TOKEN,TEXTURE_MAP_ID_TOKEN,COLOUR_ID_TOKEN)
      CASE4 (PIGMENT_MAP_ID_TOKEN, MEDIA_ID_TOKEN,STRING_ID_TOKEN,INTERIOR_ID_TOKEN)
!     CASE5 (DENSITY_MAP_ID_TOKEN, ARRAY_ID_TOKEN, DENSITY_ID_TOKEN,UV_ID_TOKEN,VECTOR_4D_ID_TOKEN)
      CASE4 (RAINBOW_ID_TOKEN, FOG_ID_TOKEN, SKYSPHERE_ID_TOKEN,MATERIAL_ID_TOKEN)
        if (Local_Flag && (Token.Table_Index != Table_Index))
        {
***************
*** 4820,4827 ****
          Temp_Entry = Add_Symbol (Local_Index,Token.Token_String,IDENTIFIER_TOKEN);
          Token.NumberPtr = &(Temp_Entry->Token_Number);
          Token.DataPtr   = &(Temp_Entry->Data);
        }
-       Previous          = Token.Token_Id;
        EXIT
      END_CASE
  
--- 4829,4840 ----
          Temp_Entry = Add_Symbol (Local_Index,Token.Token_String,IDENTIFIER_TOKEN);
          Token.NumberPtr = &(Temp_Entry->Token_Number);
          Token.DataPtr   = &(Temp_Entry->Data);
+         Previous        = IDENTIFIER_TOKEN;
+       }
+       else
+       {
+         Previous        = Token.Token_Id;
        }
        EXIT
      END_CASE
  
***************
*** 4868,4874 ****
  
  int Parse_RValue (int Previous, int *NumberPtr, void **DataPtr, int ParFlag, int SemiFlag)
  {
!   VECTOR Local_Vector;
    COLOUR *Local_Colour;
    PIGMENT *Local_Pigment;
    TNORMAL *Local_Tnormal;
--- 4881,4887 ----
  
  int Parse_RValue (int Previous, int *NumberPtr, void **DataPtr, int ParFlag, int SemiFlag)
  {
!   EXPRESS Local_Express;
    COLOUR *Local_Colour;
    PIGMENT *Local_Pigment;
    TNORMAL *Local_Tnormal;
***************
*** 4886,4891 ****
--- 4899,4905 ----
    int Found=TRUE;
    int Temp_Count=30000;
    int Old_Ok=Ok_To_Declare;
+   int Terms;
    
    EXPECT
      CASE4 (TNORMAL_ID_TOKEN, FINISH_ID_TOKEN, TEXTURE_ID_TOKEN, OBJECT_ID_TOKEN)
***************
*** 4941,4947 ****
  
      CASE_VECTOR
        Ok_To_Declare = FALSE;
-       Have_Vector   = FALSE;
        if (ParFlag && 
            ( ( (Token.Token_Id==FLOAT_FUNCT_TOKEN) && 
                (Token.Function_Id==FLOAT_ID_TOKEN) 
--- 4955,4960 ----
***************
*** 4948,4960 ****
              ) ||
              ( (Token.Token_Id==VECTOR_FUNCT_TOKEN) && 
                (Token.Function_Id==VECTOR_ID_TOKEN) 
!             ) 
            ) 
           ) 
        {
           Temp_Count=token_count;
        }
!       Parse_Vector_Float (Local_Vector);
        if (SemiFlag)
        {
           Parse_Semi_Colon();
--- 4961,4976 ----
              ) ||
              ( (Token.Token_Id==VECTOR_FUNCT_TOKEN) && 
                (Token.Function_Id==VECTOR_ID_TOKEN) 
!             )  ||
!             (Token.Token_Id==VECTOR_4D_ID_TOKEN) 
!                ||
!             (Token.Token_Id==UV_ID_TOKEN) 
            ) 
           ) 
        {
           Temp_Count=token_count;
        }
!       Terms = Parse_Unknown_Vector (Local_Express);
        if (SemiFlag)
        {
           Parse_Semi_Colon();
***************
*** 4970,4988 ****
        }
        else
        {
!          if (Have_Vector)
           {
              *NumberPtr = VECTOR_ID_TOKEN;
              Test_Redefine(Previous,NumberPtr,*DataPtr);
              *DataPtr   = (void *) Create_Vector();
!             Assign_Vector(*DataPtr ,Local_Vector);
!          }
!          else
!          {
!             *NumberPtr = FLOAT_ID_TOKEN;
              Test_Redefine(Previous,NumberPtr,*DataPtr);
!             *DataPtr   = (void *) Create_Float();
!             *((DBL *)*DataPtr)  = Local_Vector[X];
           }
        } 
        Ok_To_Declare = TRUE;
--- 4986,5027 ----
        }
        else
        {
!          switch(Terms)
           {
+            case 1:
+             *NumberPtr = FLOAT_ID_TOKEN;
+             Test_Redefine(Previous,NumberPtr,*DataPtr);
+             *DataPtr   = (void *) Create_Float();
+             *((DBL *)*DataPtr)  = Local_Express[X];
+             break;
+             
+            case 2:
+             *NumberPtr = UV_ID_TOKEN;
+             Test_Redefine(Previous,NumberPtr,*DataPtr);
+             *DataPtr   = (void *) Create_UV_Vect();
+             Assign_UV_Vect(*DataPtr, Local_Express);
+             break;
+             
+            case 3:
              *NumberPtr = VECTOR_ID_TOKEN;
              Test_Redefine(Previous,NumberPtr,*DataPtr);
              *DataPtr   = (void *) Create_Vector();
!             Assign_Vector(*DataPtr, Local_Express);
!             break;
!             
!            case 4:
!             *NumberPtr = VECTOR_4D_ID_TOKEN;
              Test_Redefine(Previous,NumberPtr,*DataPtr);
!             *DataPtr   = (void *) Create_Vector_4D();
!             Assign_Vector_4D(*DataPtr, Local_Express);
!             break;
!             
!            case 5:
!             *NumberPtr    = COLOUR_ID_TOKEN;
!             Test_Redefine(Previous,NumberPtr,*DataPtr);
!             *DataPtr      = (void *) Create_Colour();
!             Assign_Colour(*DataPtr, Local_Express);
!             break;
           }
        } 
        Ok_To_Declare = TRUE;
***************
*** 5231,5236 ****
--- 5270,5281 ----
       case VECTOR_ID_TOKEN:
         Destroy_Vector((VECTOR *)Data);
         break;
+      case UV_ID_TOKEN:
+        Destroy_UV_Vect((UV_VECT *)Data);
+        break;
+      case VECTOR_4D_ID_TOKEN:
+        Destroy_Vector((VECTOR_4D *)Data);
+        break;
       case FLOAT_ID_TOKEN:
         Destroy_Float((DBL *)Data);
         break;
***************
*** 5789,5794 ****
--- 5834,5840 ----
        Post_Process(Sib, Object);
      }
    }
+   /* [removed by CEY 01/98]
    else
    {
      if (Object->Texture != NULL)
***************
*** 5802,5808 ****
        }
      }
    }
! 
    /* Test wether the object is finite or infinite. [DB 9/94] */
  
    BOUNDS_VOLUME(Volume, Object->BBox);
--- 5848,5854 ----
        }
      }
    }
!   */
    /* Test wether the object is finite or infinite. [DB 9/94] */
  
    BOUNDS_VOLUME(Volume, Object->BBox);
***************
*** 6102,6107 ****
--- 6148,6155 ----
    POV_ARRAY *a, *na;
    VECTOR *vp;
    DBL *dp;
+   UV_VECT *uvp;
+   VECTOR_4D *v4p;
    void *New;
    
    if (Data==NULL)
***************
*** 6118,6123 ****
--- 6166,6181 ----
         vp = Create_Vector();
         Assign_Vector((*vp),(*((VECTOR *)Data)));
         New=vp;
+        break;
+      case UV_ID_TOKEN:
+        uvp = Create_UV_Vect();
+        Assign_Vector((*uvp),(*((UV_VECT *)Data)));
+        New=uvp;
+        break;
+      case VECTOR_4D_ID_TOKEN:
+        v4p = Create_Vector_4D();
+        Assign_Vector((*v4p),(*((VECTOR_4D *)Data)));
+        New=v4p;
         break;
       case FLOAT_ID_TOKEN:
         dp = Create_Float();
diff -c3 -o -r ./source/parse.h \povray3/source/parse.h
*** ./source/parse.h	Mon Aug 31 13:50:22 1998
--- \povray3/source/parse.h	Wed Jan  6 21:06:30 1999
***************
*** 53,59 ****
  #define CASE_FLOAT CASE2 (LEFT_PAREN_TOKEN, FLOAT_FUNCT_TOKEN)\
   CASE2 (PLUS_TOKEN, DASH_TOKEN) UNGET
  #define CASE_VECTOR CASE2 (VECTOR_FUNCT_TOKEN,LEFT_ANGLE_TOKEN) \
!  CASE2 (U_TOKEN,V_TOKEN) CASE_FLOAT
  #define CASE_EXPRESS CASE_VECTOR
  
  #define CASE_COLOUR CASE3 (COLOUR_TOKEN,COLOUR_KEY_TOKEN,COLOUR_ID_TOKEN) UNGET
--- 53,59 ----
  #define CASE_FLOAT CASE2 (LEFT_PAREN_TOKEN, FLOAT_FUNCT_TOKEN)\
   CASE2 (PLUS_TOKEN, DASH_TOKEN) UNGET
  #define CASE_VECTOR CASE2 (VECTOR_FUNCT_TOKEN,LEFT_ANGLE_TOKEN) \
!  CASE4 (U_TOKEN,V_TOKEN,UV_ID_TOKEN,VECTOR_4D_ID_TOKEN) CASE_FLOAT
  #define CASE_EXPRESS CASE_VECTOR
  
  #define CASE_COLOUR CASE3 (COLOUR_TOKEN,COLOUR_KEY_TOKEN,COLOUR_ID_TOKEN) UNGET
***************
*** 501,506 ****
--- 501,508 ----
    EXTINCTION_TOKEN,
    MATERIAL_TOKEN,
    MATERIAL_ID_TOKEN,
+   UV_ID_TOKEN,
+   VECTOR_4D_ID_TOKEN,
    LAST_TOKEN
  };
  
diff -c3 -o -r ./source/parstxtr.c \povray3/source/parstxtr.c
*** ./source/parstxtr.c	Mon Aug 31 19:02:32 1998
--- \povray3/source/parstxtr.c	Wed Jan  6 21:53:54 1999
***************
*** 118,130 ****
       {
        EXPECT
          CASE_VECTOR
!           Warn(1.5, "Should use map_type keyword and/or eliminate orientation.");
!           Have_Vector = FALSE;
!           Parse_Vector_Float (Local_Vector);
!           if (Have_Vector)
!             Assign_Vector(Image->Gradient,Local_Vector);
!           else
!             Image->Map_Type = (int)Local_Vector[X];
          END_CASE
  
          OTHERWISE
--- 118,125 ----
       {
        EXPECT
          CASE_VECTOR
!           Warn(1.5, "Old style orientation vector or map type not supported.  Ignoring value.");
!           Parse_Vector (Local_Vector);
          END_CASE
  
          OTHERWISE
***************
*** 752,758 ****
     EXPECT         /* Look for pattern_modifier */
       CASE (TURBULENCE_TOKEN)
         Local_Turb=Check_Turb(&(New->Warps));
!        Parse_Vector_Float(Local_Turb->Turbulence);
       END_CASE
  
       CASE (COLOUR_MAP_TOKEN)
--- 747,753 ----
     EXPECT         /* Look for pattern_modifier */
       CASE (TURBULENCE_TOKEN)
         Local_Turb=Check_Turb(&(New->Warps));
!        Parse_Vector(Local_Turb->Turbulence);
       END_CASE
  
       CASE (COLOUR_MAP_TOKEN)
***************
*** 1002,1007 ****
--- 997,1007 ----
         EXIT
       END_CASE
     END_EXPECT
+    
+    if ((New->Type==AVERAGE_PATTERN) && (New->Blend_Map==NULL))
+    {
+       Error("Average must have map.");
+    }
  
     if ((TPat_Type==TEXTURE_TYPE) && (New->Type!=PLAIN_PATTERN) &&
         (New->Blend_Map==NULL))
***************
*** 1177,1183 ****
           END_CASE
  
           CASE (TURBULENCE_TOKEN)                /* DMF */
!            Parse_Vector_Float(Local_Vector);
             New->Irid_Turb = Local_Vector[X];
           END_CASE
  
--- 1177,1183 ----
           END_CASE
  
           CASE (TURBULENCE_TOKEN)                /* DMF */
!            Parse_Vector(Local_Vector);
             New->Irid_Turb = Local_Vector[X];
           END_CASE
  
***************
*** 1795,1801 ****
  
           CASE (TURBULENCE_TOKEN)
             Local_Turb=Check_Turb(&(Pigment->Warps));
!            Parse_Vector_Float(Local_Turb->Turbulence);
           END_CASE
  
           CASE (COLOUR_MAP_TOKEN)
--- 1795,1801 ----
  
           CASE (TURBULENCE_TOKEN)
             Local_Turb=Check_Turb(&(Pigment->Warps));
!            Parse_Vector(Local_Turb->Turbulence);
           END_CASE
  
           CASE (COLOUR_MAP_TOKEN)
***************
*** 2515,2521 ****
        {
          Fog->Turb=(TURB *)Create_Warp(CLASSIC_TURB_WARP);
        }
!       Parse_Vector_Float(Fog->Turb->Turbulence);
      END_CASE
  
      CASE (OCTAVES_TOKEN)
--- 2515,2521 ----
        {
          Fog->Turb=(TURB *)Create_Warp(CLASSIC_TURB_WARP);
        }
!       Parse_Vector(Fog->Turb->Turbulence);
      END_CASE
  
      CASE (OCTAVES_TOKEN)
diff -c3 -o -r ./source/png_pov.c \povray3/source/png_pov.c
*** ./source/png_pov.c	Mon Jun  1 18:12:08 1998
--- \povray3/source/png_pov.c	Mon Nov  9 18:10:32 1998
***************
*** 116,122 ****
  static void png_pov_warn (png_structp, png_const_charp);
  
  /* This is an internal function for libpng */
! extern void png_write_finish_row (png_structp);
  
  /*****************************************************************************
  *
--- 116,132 ----
  static void png_pov_warn (png_structp, png_const_charp);
  
  /* This is an internal function for libpng */
! extern 
! #ifdef __cplusplus
!  "C" {
! #endif
! 
! void png_write_finish_row (png_structp);
! 
! #ifdef __cplusplus
! }
! #endif
! 
  
  /*****************************************************************************
  *
diff -c3 -o -r ./source/prism.c \povray3/source/prism.c
*** ./source/prism.c	Mon Jun  1 18:12:52 1998
--- \povray3/source/prism.c	Wed Jan 13 16:34:46 1999
***************
*** 531,567 ****
        }
        else
        {
!         /* Intersect ray with the cap-plane. */
! 
!         k = (Prism->Height2 - P[Y]) / D[Y];
! 
!         if ((k > DEPTH_TOLERANCE) && (k < Max_Distance))
          {
!           u = (P[X] + k * D[X]) / Prism->Height2;
!           v = (P[Z] + k * D[Z]) / Prism->Height2;
  
!           if (in_curve(Prism, u, v))
            {
!             Intersection[i].t   = CAP_HIT;
!             Intersection[i++].d = k / len;
!           }
!         }
  
!         /* Intersect ray with the base-plane. */
  
!         if (Prism->Height1 > 0.0)
!         {
!           k = (Prism->Height1 - P[Y]) / D[Y];
  
!           if ((k > DEPTH_TOLERANCE) && (k < Max_Distance))
            {
!             u = (P[X] + k * D[X]) / Prism->Height1;
!             v = (P[Z] + k * D[Z]) / Prism->Height1;
  
!             if (in_curve(Prism, u, v))
              {
!               Intersection[i].t   = BASE_HIT;
!               Intersection[i++].d = k / len;
              }
            }
          }
--- 531,573 ----
        }
        else
        {
!         if (Test_Flag(Prism, CLOSED_FLAG))
          {
!           /* Intersect ray with the cap-plane. */
  
!           if (fabs(Prism->Height2) > EPSILON)
            {
!             k = (Prism->Height2 - P[Y]) / D[Y];
  
!             if ((k > DEPTH_TOLERANCE) && (k < Max_Distance))
!             {
!               u = (P[X] + k * D[X]) / Prism->Height2;
!               v = (P[Z] + k * D[Z]) / Prism->Height2;
  
!               if (in_curve(Prism, u, v))
!               {
!                 Intersection[i].t   = CAP_HIT;
!                 Intersection[i++].d = k / len;
!               }
!             }
!           }
! 
!           /* Intersect ray with the base-plane. */
  
!           if (fabs(Prism->Height1) > EPSILON)
            {
!             k = (Prism->Height1 - P[Y]) / D[Y];
  
!             if ((k > DEPTH_TOLERANCE) && (k < Max_Distance))
              {
!               u = (P[X] + k * D[X]) / Prism->Height1;
!               v = (P[Z] + k * D[Z]) / Prism->Height1;
! 
!               if (in_curve(Prism, u, v))
!               {
!                 Intersection[i].t   = BASE_HIT;
!                 Intersection[i++].d = k / len;
!               }
              }
            }
          }
***************
*** 758,764 ****
      {
        /* Scale x and z coordinate. */
  
!       if (P[Y] > 0.0)
        {
          P[X] /= P[Y];
          P[Z] /= P[Y];
--- 764,770 ----
      {
        /* Scale x and z coordinate. */
  
!       if (fabs(P[Y]) > EPSILON)
        {
          P[X] /= P[Y];
          P[Z] /= P[Y];
***************
*** 843,849 ****
  
          MInvTransPoint(P, Inter->IPoint, Prism->Trans);
  
!         if (P[Y] > 0.0)
          {
            N[X] =   Inter->d1 * (3.0 * Entry.A[Y] * Inter->d1 + 2.0 * Entry.B[Y]) + Entry.C[Y];
            N[Z] = -(Inter->d1 * (3.0 * Entry.A[X] * Inter->d1 + 2.0 * Entry.B[X]) + Entry.C[X]);
--- 849,855 ----
  
          MInvTransPoint(P, Inter->IPoint, Prism->Trans);
  
!         if (fabs(P[Y]) > EPSILON)
          {
            N[X] =   Inter->d1 * (3.0 * Entry.A[Y] * Inter->d1 + 2.0 * Entry.B[Y]) + Entry.C[Y];
            N[Z] = -(Inter->d1 * (3.0 * Entry.A[X] * Inter->d1 + 2.0 * Entry.B[X]) + Entry.C[X]);
***************
*** 1100,1105 ****
--- 1106,1115 ----
    New->x2      =
    New->y1      =
    New->y2      =
+   New->u1      =
+   New->u2      =
+   New->v1      =
+   New->v2      =
    New->Height1 =
    New->Height2 = 0.0;
  
***************
*** 1316,1323 ****
  
    /* First test overall bounding rectangle. */
    
!   if ((u >= Prism->x1) && (u <= Prism->x2) &&
!       (v >= Prism->y1) && (v <= Prism->y2))
    {
      for (i = 0; i < Prism->Number; i++)
      {
--- 1326,1333 ----
  
    /* First test overall bounding rectangle. */
    
!   if ((u >= Prism->u1) && (u <= Prism->u2) &&
!       (v >= Prism->v1) && (v <= Prism->v2))
    {
      for (i = 0; i < Prism->Number; i++)
      {
***************
*** 1325,1331 ****
  
        /* Test if current segment can be hit. */
  
!       if ((v >= Entry.y1) && (v <= Entry.y2) && (u <= Entry.x2))
        {
          x[0] = Entry.A[Y];
          x[1] = Entry.B[Y];
--- 1335,1341 ----
  
        /* Test if current segment can be hit. */
  
!       if ((v >= Entry.v1) && (v <= Entry.v2) && (u <= Entry.u2))
        {
          x[0] = Entry.A[Y];
          x[1] = Entry.B[Y];
***************
*** 1769,1779 ****
      /* Set current segment's bounding rectangle. */
  
      Prism->Spline->Entry[number_of_splines].x1 = min(min(x[0], x[1]), min(x[2], x[3]));
!     Prism->Spline->Entry[number_of_splines].x2 = max(max(x[0], x[1]), max(x[2], x[3]));
  
!     Prism->Spline->Entry[number_of_splines].y1 = min(min(y[0], y[1]), min(y[2], y[3]));
!     Prism->Spline->Entry[number_of_splines].y2 = max(max(y[0], y[1]), max(y[2], y[3]));
  
      /* Keep track of overall bounding rectangle. */
  
      xmin = min(xmin, Prism->Spline->Entry[number_of_splines].x1);
--- 1779,1794 ----
      /* Set current segment's bounding rectangle. */
  
      Prism->Spline->Entry[number_of_splines].x1 = min(min(x[0], x[1]), min(x[2], x[3]));
! 
!     Prism->Spline->Entry[number_of_splines].x2 =
!     Prism->Spline->Entry[number_of_splines].u2 = max(max(x[0], x[1]), max(x[2], x[3]));
  
!     Prism->Spline->Entry[number_of_splines].y1 =
!     Prism->Spline->Entry[number_of_splines].v1 = min(min(y[0], y[1]), min(y[2], y[3]));
  
+     Prism->Spline->Entry[number_of_splines].y2 =
+     Prism->Spline->Entry[number_of_splines].v2 = max(max(y[0], y[1]), max(y[2], y[3]));
+ 
      /* Keep track of overall bounding rectangle. */
  
      xmin = min(xmin, Prism->Spline->Entry[number_of_splines].x1);
***************
*** 1845,1855 ****
  
    /* Set overall bounding rectangle. */
  
!   Prism->x1 = xmin;
!   Prism->x2 = xmax;
! 
!   Prism->y1 = ymin;
!   Prism->y2 = ymax;
  
    if (Prism->Sweep_Type == CONIC_SWEEP)
    {
--- 1860,1874 ----
  
    /* Set overall bounding rectangle. */
  
!   Prism->x1 =
!   Prism->u1 = xmin;
!   Prism->x2 =
!   Prism->u2 = xmax;
! 
!   Prism->y1 =
!   Prism->v1 = ymin;
!   Prism->y2 =
!   Prism->v2 = ymax;
  
    if (Prism->Sweep_Type == CONIC_SWEEP)
    {
diff -c3 -o -r ./source/prism.h \povray3/source/prism.h
*** ./source/prism.h	Fri May 22 16:48:26 1998
--- \povray3/source/prism.h	Wed Jan 13 16:24:38 1999
***************
*** 67,72 ****
--- 67,73 ----
  struct Prism_Spline_Entry_Struct
  {
    DBL x1, y1, x2, y2;  /* Min./Max. coordinates of segment   */
+   DBL v1, u2, v2;      /* Min./Max. coordinates of segment in <u,v>, u1 not needed  */
    UV_VECT A, B, C, D;  /* Coefficients of segment            */
  };
  
***************
*** 87,92 ****
--- 88,94 ----
    DBL x1, y1, x2, y2;       /* Overall bounding rectangle of spline curve */
    PRISM_SPLINE *Spline;     /* Pointer to array of splines                */
    PRISM_INT *Intersections; /* Prism intersections list                   */
+   DBL u1, v1, u2, v2;       /* Overall <u,v> bounding rectangle of spline */
  };
  
  
diff -c3 -o -r ./source/render.c \povray3/source/render.c
*** ./source/render.c	Sun Aug  9 21:54:18 1998
--- \povray3/source/render.c	Mon Jan 18 18:41:04 1999
***************
*** 706,712 ****
  
  void Read_Rendered_Part(char *New_Fname)
  {
!   int rc, x, line_number = 0;
    unsigned char Red, Green, Blue, Alpha;
    DBL grey;
  
--- 706,712 ----
  
  void Read_Rendered_Part(char *New_Fname)
  {
!   int rc, x, line_number = -1;
    unsigned char Red, Green, Blue, Alpha;
    DBL grey;
  
***************
*** 728,733 ****
--- 728,737 ----
    }
  
    opts.First_Line = line_number + 1;
+   if(opts.First_Line < 1)
+   {
+     opts.First_Line = 1;
+   }
  
    Close_File(Output_File_Handle);
  
***************
*** 2338,2345 ****
  
          Clip_Colour(C, C);
  
-         gamma_correct(C);
- 
          Add_Colour(Colour, Colour, C);
        }
        else
--- 2342,2347 ----
***************
*** 2384,2389 ****
--- 2386,2393 ----
    while (nr < Frame.Camera->Blur_Samples);
  
    Scale_Colour(Colour, Colour, 1.0 / (DBL)nr);
+ 
+   gamma_correct(Colour);
  }
  
  
***************
*** 3373,3379 ****
    if (opts.histogram_on)
    {
      PRECISION_TIMER_INIT
!     histogram_grid = POV_CALLOC (opts.histogram_x * opts.histogram_y,
                                   sizeof(unsigned long), "histogram grid");
    }
  #else
--- 3377,3383 ----
    if (opts.histogram_on)
    {
      PRECISION_TIMER_INIT
!     histogram_grid = (unsigned long *)POV_CALLOC (opts.histogram_x * opts.histogram_y,
                                   sizeof(unsigned long), "histogram grid");
    }
  #else
diff -c3 -o -r ./source/texture.c \povray3/source/texture.c
*** ./source/texture.c	Mon Sep 28 15:17:46 1998
--- \povray3/source/texture.c	Mon Jan 18 15:53:30 1999
***************
*** 215,221 ****
  
  static void InitTextureTable()
  {
!   int i, j, temp;
  
    POV_SRAND(0);
  
--- 215,221 ----
  
  static void InitTextureTable()
  {
!   short int i, j, temp;
  
    POV_SRAND(0);
  
diff -c3 -o -r ./source/tokenize.c \povray3/source/tokenize.c
*** ./source/tokenize.c	Sun Sep 13 13:57:56 1998
--- \povray3/source/tokenize.c	Mon Jan 18 18:24:20 1999
***************
*** 532,537 ****
--- 532,538 ----
    {USE_COLOUR_TOKEN, "use_color"},
    {USE_COLOUR_TOKEN, "use_colour"},
    {USE_INDEX_TOKEN, "use_index"},
+   {UV_ID_TOKEN, "uv vector identifier"},
    {U_STEPS_TOKEN, "u_steps"},
    {U_TOKEN, "u"},
    {VAL_TOKEN, "val"},
***************
*** 539,544 ****
--- 540,546 ----
    {VAXIS_ROTATE_TOKEN, "vaxis_rotate"},
    {VCROSS_TOKEN, "vcross"},
    {VDOT_TOKEN, "vdot"},
+   {VECTOR_4D_ID_TOKEN, "4d-vector identifier"},
    {VECTOR_FUNCT_TOKEN, "vector function"},
    {VECTOR_ID_TOKEN, "vector identifier"},
    {VERSION_TOKEN, "version"},
***************
*** 2603,2609 ****
            CASE4 (PIGMENT_MAP_ID_TOKEN, MEDIA_ID_TOKEN,STRING_ID_TOKEN,INTERIOR_ID_TOKEN)
            CASE4 (ARRAY_ID_TOKEN, DENSITY_ID_TOKEN, DENSITY_MAP_ID_TOKEN, FILE_ID_TOKEN)
            CASE4 (FOG_ID_TOKEN, MACRO_ID_TOKEN, PARAMETER_ID_TOKEN, RAINBOW_ID_TOKEN)
!           CASE2 (SKYSPHERE_ID_TOKEN,MATERIAL_ID_TOKEN)
              Remove_Symbol (Token.Table_Index,Token.Token_String);
              EXIT
            END_CASE
--- 2605,2611 ----
            CASE4 (PIGMENT_MAP_ID_TOKEN, MEDIA_ID_TOKEN,STRING_ID_TOKEN,INTERIOR_ID_TOKEN)
            CASE4 (ARRAY_ID_TOKEN, DENSITY_ID_TOKEN, DENSITY_MAP_ID_TOKEN, FILE_ID_TOKEN)
            CASE4 (FOG_ID_TOKEN, MACRO_ID_TOKEN, PARAMETER_ID_TOKEN, RAINBOW_ID_TOKEN)
!           CASE4 (SKYSPHERE_ID_TOKEN,MATERIAL_ID_TOKEN,UV_ID_TOKEN,VECTOR_4D_ID_TOKEN)
              Remove_Symbol (Token.Table_Index,Token.Token_String);
              EXIT
            END_CASE
***************
*** 2757,2765 ****
  
     Include_File_Index++;
  
!    if (Include_File_Index > MAX_INCLUDE_FILES)
       Error ("Too many nested include files.\n");
! 
     temp = Parse_String();
  
     UICB_OPEN_INCLUDE_FILE  /* Notify UI that we are about to open an include file */
--- 2759,2769 ----
  
     Include_File_Index++;
  
!    if (Include_File_Index >= MAX_INCLUDE_FILES)
!    {
!      Include_File_Index--;
       Error ("Too many nested include files.\n");
!    }
     temp = Parse_String();
  
     UICB_OPEN_INCLUDE_FILE  /* Notify UI that we are about to open an include file */
***************
*** 2913,2920 ****
  
    SYM_TABLE *New;
  
!   if ((Table_Index++)==MAX_NUMBER_OF_TABLES)
    {
      Error("Too many nested symbol tables");
    }
    
--- 2917,2925 ----
  
    SYM_TABLE *New;
  
!   if ((++Table_Index)==MAX_NUMBER_OF_TABLES)
    {
+     Table_Index--;
      Error("Too many nested symbol tables");
    }
    
***************
*** 3124,3129 ****
--- 3129,3135 ----
      CASE4 (PIGMENT_MAP_ID_TOKEN, MEDIA_ID_TOKEN,STRING_ID_TOKEN,INTERIOR_ID_TOKEN)
      CASE4 (ARRAY_ID_TOKEN, DENSITY_ID_TOKEN, DENSITY_MAP_ID_TOKEN, FILE_ID_TOKEN)
      CASE4 (FOG_ID_TOKEN, RAINBOW_ID_TOKEN, SKYSPHERE_ID_TOKEN,MATERIAL_ID_TOKEN)
+     CASE2 (UV_ID_TOKEN,VECTOR_4D_ID_TOKEN)
        New->Par_Name[New->Num_Of_Pars] = POV_STRDUP(Token.Token_String);
        if (++(New->Num_Of_Pars) == MAX_PARAMETER_LIST)
        {
***************
*** 3461,3466 ****
--- 3467,3473 ----
         Data=(DATA_FILE *)Token.Data;
         fflush(Data->File);
         fclose(Data->File);
+        Data->File = NULL;       /* <--- this line added -hdf- */
         Remove_Symbol (1,Token.Token_String);
         EXIT
       END_CASE
***************
*** 3545,3550 ****
--- 3552,3558 ----
     if (End_File)
     {
        fclose(User_File->File);
+       User_File->File = NULL;   /* <--- this line added -hdf- */
        Remove_Symbol (1,File_Id);
     }
     POV_FREE(File_Id);
***************
*** 3639,3645 ****
       END_CASE
       
       CASE_VECTOR
!        Parse_Vector_Float (Vect);
         if (Have_Vector)
         {
           fprintf(User_File->File,"<%g,%g,%g> ",Vect[X],Vect[Y],Vect[Z]);
--- 3647,3653 ----
       END_CASE
       
       CASE_VECTOR
!        Parse_Unknown_Vector (Vect);
         if (Have_Vector)
         {
           fprintf(User_File->File,"<%g,%g,%g> ",Vect[X],Vect[Y],Vect[Z]);
diff -c3 -o -r ./source/triangle.c \povray3/source/triangle.c
*** ./source/triangle.c	Mon Jun  1 18:13:58 1998
--- \povray3/source/triangle.c	Wed Jan  6 15:39:42 1999
***************
*** 47,53 ****
  ******************************************************************************/
  
  static void find_triangle_dominant_axis (TRIANGLE *Triangle);
! static void compute_smooth_triangle  (SMOOTH_TRIANGLE *Triangle);
  static int Intersect_Triangle  (RAY *Ray, TRIANGLE *Triangle, DBL *Depth);
  static int All_Triangle_Intersections  (OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack);
  static int Inside_Triangle  (VECTOR IPoint, OBJECT *Object);
--- 47,53 ----
  ******************************************************************************/
  
  static void find_triangle_dominant_axis (TRIANGLE *Triangle);
! static int compute_smooth_triangle  (SMOOTH_TRIANGLE *Triangle);
  static int Intersect_Triangle  (RAY *Ray, TRIANGLE *Triangle, DBL *Depth);
  static int All_Triangle_Intersections  (OBJECT *Object, RAY *Ray, ISTACK *Depth_Stack);
  static int Inside_Triangle  (VECTOR IPoint, OBJECT *Object);
***************
*** 158,164 ****
  *
  ******************************************************************************/
  
! static void compute_smooth_triangle(SMOOTH_TRIANGLE *Triangle)
  {
    VECTOR P3MinusP2, VTemp1, VTemp2;
    DBL x, y, z, uDenominator, Proj;
--- 158,164 ----
  *
  ******************************************************************************/
  
! static int compute_smooth_triangle(SMOOTH_TRIANGLE *Triangle)
  {
    VECTOR P3MinusP2, VTemp1, VTemp2;
    DBL x, y, z, uDenominator, Proj;
***************
*** 188,193 ****
--- 188,206 ----
    VDot(uDenominator, VTemp2, Triangle->Perp);
  
    VInverseScaleEq(Triangle->Perp, -uDenominator);
+   
+   /* Degenerate if smooth normals are more than 90 from actual normal
+      or its inverse. */
+   VDot(x,Triangle->Normal_Vector,Triangle->N1);
+   VDot(y,Triangle->Normal_Vector,Triangle->N2);
+   VDot(z,Triangle->Normal_Vector,Triangle->N3);
+   if ( ((x<0.0) && (y<0.0) && (z<0.0)) ||
+        ((x>0.0) && (y>0.0) && (z>0.0)) )
+   {
+     return(TRUE);
+   }
+   Set_Flag(Triangle, DEGENERATE_FLAG);
+   return(FALSE);
  }
  
  
***************
*** 220,226 ****
  
  int Compute_Triangle(TRIANGLE *Triangle,int Smooth)
  {
!   int swap;
    VECTOR V1, V2, Temp;
    DBL Length;
  
--- 233,239 ----
  
  int Compute_Triangle(TRIANGLE *Triangle,int Smooth)
  {
!   int swap,degn;
    VECTOR V1, V2, Temp;
    DBL Length;
  
***************
*** 298,307 ****
        Assign_Vector(((SMOOTH_TRIANGLE *)Triangle)->N1, Temp);
      }
    }
  
    if (Smooth)
    {
!     compute_smooth_triangle((SMOOTH_TRIANGLE *)Triangle);
    }
  
    /* Build the bounding information from the vertices. */
--- 311,322 ----
        Assign_Vector(((SMOOTH_TRIANGLE *)Triangle)->N1, Temp);
      }
    }
+   
+   degn=TRUE;
  
    if (Smooth)
    {
!     degn=compute_smooth_triangle((SMOOTH_TRIANGLE *)Triangle);
    }
  
    /* Build the bounding information from the vertices. */
***************
*** 308,314 ****
  
    Compute_Triangle_BBox(Triangle);
  
!   return(TRUE);
  }
  
  
--- 323,329 ----
  
    Compute_Triangle_BBox(Triangle);
  
!   return(degn);
  }
  
  
